' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports System.Data.SqlClient

''' <summary>
''' Klasa AppointmentManagerDB odpowiada za sprawdzanie, pobieranie i dodawanie rezerwacji do bazy danych.
''' Potrafi te pobiera informacje na temat dostpnoci rezerwacji.
''' </summary>
''' <remarks>Poniewa klasa ta zawiera tylko metody wspdzielone, jej konstruktor zosta oznaczony jako prywatny, wic nie mona tworzy jej egzemplarzy.</remarks>
Public Class AppointmentManagerDB

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy AppointmentManagerDB.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca wszystkie obiekty rezerwacji oraz rezerwacje jako dwie tabele z danymi poaczone relacj wewntrz DataSet wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <param name="selectedDate">Dzie, dla ktrego naley pobra rezerwacje.</param>
  Public Shared Function GetAppointmentList(ByVal selectedDate As DateTime) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
      Try
        Dim myCommand As SqlCommand = New SqlCommand("sprocAppointmentSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@selectedDate", selectedDate)

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)

        ' Bezporednio okrel kad tabel, dla ktrej bdziemy tworzy relacj, jej wasn nazw
        ' a nie "magicznymi numerami".
        myDataSet.Tables(0).TableName = "BookingObject"
        myDataSet.Tables(1).TableName = "Appointment"

        myDataSet.Relations.Add("BookingObjectAppointment", myDataSet.Tables("BookingObject").Columns("Id"), _
                         myDataSet.Tables("Appointment").Columns("BookingObjectId"))

        Return myDataSet
      Catch ex As Exception
        ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
        Throw
      Finally
        myConnection.Close()
      End Try
    End Using
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy obiekt Appointment w oparciu o jego identyfikator wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <param name="id">Identyfikator rezerwacji w bazie danych.</param>
  ''' <returns>dana rezerwacja, jeli pozycja zostaa znaleziona w bazie danych lub <see langword="null" /> jesli nie mona byo znale pozycji.</returns>
  Public Shared Function GetAppointment(ByVal id As Integer) As Appointment
    Dim myAppointment As Appointment = Nothing

    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocAppointmentSelectSingleItem", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@id", id)

        myConnection.Open()
        Using myReader As SqlDataReader = _
              myCommand.ExecuteReader(CommandBehavior.CloseConnection)
          If myReader.Read() Then
            myAppointment = New Appointment()
            myAppointment.Id = myReader.GetInt32(myReader.GetOrdinal("Id"))
            myAppointment.StartDate = Convert.ToDateTime(myReader.GetValue(myReader.GetOrdinal("StartDate")))
            myAppointment.EndDate = Convert.ToDateTime(myReader.GetValue(myReader.GetOrdinal("EndDate")))
            myAppointment.BookingObjectId = Convert.ToInt32(myReader.GetValue(myReader.GetOrdinal("BookingObjectId")))
            If myReader.GetValue(myReader.GetOrdinal("Comments")) IsNot DBNull.Value Then
              myAppointment.Comments = myReader.GetValue(myReader.GetOrdinal("Comments")).ToString()
            End If
            myAppointment.UserName = myReader.GetValue(myReader.GetOrdinal("UserName")).ToString()
            myAppointment.UserEmailAddress = myReader.GetValue(myReader.GetOrdinal("UserEmailAddress")).ToString()
          End If
          myReader.Close()

        End Using
      End Using
    Catch
      Throw
    Finally

    End Try
    Return myAppointment
  End Function

  ''' <summary>
  ''' Sprawdza poprawno biecej rezerwacji wywoujc procedur skadowan, aby upewni si, e 
  ''' nie koliduje z innymi rezerwacjami dla danego obiektu rezerwacji.
  ''' </summary>
  ''' <param name="myAppointment">Rezerwacja, ktrej poprawno ma by sprawdzona.</param>
  ''' <returns>Zwraca True, gdy rezerwacja nie koliduje z istniejc rezerwacj lub False w przeciwnym razie.</returns>
  Public Shared Function CheckAppointment(ByVal myAppointment As Appointment) As Boolean
    Try
      Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
        Dim myCommand As SqlCommand = New SqlCommand("sprocAppointmentCheckAvailability", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@bookingObjectId", myAppointment.BookingObjectId)
        myCommand.Parameters.AddWithValue("@startDate", myAppointment.StartDate)
        myCommand.Parameters.AddWithValue("@endDate", myAppointment.EndDate)

        Try
          myConnection.Open()

          ' Procedura skadowana zwraca liczb dostpnych przedziaw czasu dla rezerwacji.
          ' 0 oznacza, e nie ma dostpnego czasu, liczba dodatnia oznacza, e rezerwacja moe by dokonana.
          Return Convert.ToInt32(myCommand.ExecuteScalar()) > 0
        Catch ex As Exception
          Throw
        Finally
          myConnection.Close()
        End Try
      End Using
    Catch ex As Exception
      ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
      Throw
    End Try
  End Function

  ''' <summary>
  ''' Zapisuje rezerwacje w bazie danych wykonujc procedur skadowan.
  ''' </summary>
  ''' <param name="myAppointment">Obiekt <see cref="Appointment" />, ktry ma by zapisany.</param>
  ''' <remarks>Ze wzgledw bezpieczestwa ta metoda wywouje jeszcze raz metod CheckAppointment, aby upewni si, e 
  ''' rezerwacja nie bdzie kolidowa z innymi rezerwacjami.</remarks>
  ''' <returns>Zwraca True, gdy dany dzie i czas by dostpny i rezerwacja zostaa zapisana pomylnie.
  ''' Zwraca False w przeciwnym razie.</returns>
  Public Shared Function CreateAppointment(ByVal myAppointment As Appointment) As Boolean
    ' Upewnij si, e rezerwacja nie koliduje z innymi
    If CheckAppointment(myAppointment) Then
      Try
        Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
          Dim myCommand As SqlCommand = New SqlCommand("sprocAppointmentInsertSingleItem", myConnection)
          myCommand.CommandType = CommandType.StoredProcedure

          myCommand.Parameters.AddWithValue("@userName", myAppointment.UserName)
          myCommand.Parameters.AddWithValue("@userEmailAddress", myAppointment.UserEmailAddress)
          myCommand.Parameters.AddWithValue("@startDate", myAppointment.StartDate)
          myCommand.Parameters.AddWithValue("@endDate", myAppointment.EndDate)
          If myAppointment.Comments.Length > 0 Then
            myCommand.Parameters.AddWithValue("@comments", myAppointment.Comments)
          Else
            myCommand.Parameters.AddWithValue("@comments", DBNull.Value)
          End If
          myCommand.Parameters.AddWithValue("@bookingObjectId", myAppointment.BookingObjectId)

          Try
            myConnection.Open()
            myCommand.ExecuteNonQuery()
          Catch ex As Exception
            Throw
          Finally
            myConnection.Close()
          End Try
        End Using
      Catch ex As Exception
        ' Przepu bd; zostanie przechwycony przez kod z pliku Global.asax i standardow stron bdu zdefiniowan w web.config.
        Throw
      End Try

      Return True
    Else
      Return False
    End If
  End Function

  ''' <summary>
  ''' Zwraca wszystkie obiekty rezerwacji oraz rezerwacje jako dwie tabele z danymi poaczone relacj wewntrz DataSet wykonujc zapytanie do bazy danych.
  ''' </summary>
  ''' <param name="selectedDate">Data, dla ktrej maj by pobrane rezerwacje.</param>
  Public Shared Function GetTimeSheet(ByVal selectedDate As DateTime) As DataSet
    Dim myDataSet As DataSet = New DataSet()

    Using myConnection As New SqlConnection(AppConfiguration.ConnectionString)
      Try
        Dim myCommand As SqlCommand = _
                New SqlCommand("sprocTimesheetSelectList", myConnection)
        myCommand.CommandType = CommandType.StoredProcedure

        myCommand.Parameters.AddWithValue("@selectedDate", selectedDate)

        Dim myDataAdapter As SqlDataAdapter = New SqlDataAdapter()
        myDataAdapter.SelectCommand = myCommand
        myDataAdapter.Fill(myDataSet)

        myDataSet.Tables(0).TableName = "BookingObject"
        myDataSet.Tables(1).TableName = "Appointment"

        myDataSet.Relations.Add("BookingObjectAppointment", _
            myDataSet.Tables("BookingObject").Columns("Id"), _
            myDataSet.Tables("Appointment").Columns("BookingObjectId"))

        Return myDataSet
      Catch ex As Exception
        Throw
      Finally
        myConnection.Close()
      End Try
    End Using
  End Function


End Class
